async function analyze() {
    const amount = document.getElementById('amount').value;
    const hour = document.getElementById('hour').value;
    const type = document.getElementById('type').value;
    const merch = document.getElementById('merch').value;

    if (!amount || !hour) { alert("Input data required."); return; }

    // Call Backend
    const res = await fetch('/api/scan', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ amount, hour, type, merch_risk: merch })
    });

    const data = await res.json();

    // Show Result Overlay
    const overlay = document.getElementById('result-overlay');
    const title = document.getElementById('final-verdict');
    const conf = document.getElementById('conf-level');

    overlay.classList.remove('hidden');
    title.innerText = data.status;
    conf.innerText = `AI Confidence: ${data.confidence}`;

    if (data.status === "FRAUD") {
        title.className = "fraud-text";
    } else {
        title.className = "safe-text";
    }

    refreshStats();
}

function resetScan() {
    document.getElementById('result-overlay').classList.add('hidden');
    document.getElementById('amount').value = '';
}

async function refreshStats() {
    const res = await fetch('/api/stats');
    const data = await res.json();

    document.getElementById('total-scanned').innerText = data.total;
    document.getElementById('fraud-detected').innerText = data.fraud_total;

    const tbody = document.querySelector('#log-table tbody');
    tbody.innerHTML = '';

    data.recent.forEach(row => {
        // row: [id, amount, hour, prediction, confidence, timestamp]
        let color = row[3] === 'FRAUD' ? '#da3633' : '#2ea043';
        tbody.innerHTML += `
            <tr>
                <td>${row[5]}</td>
                <td>$${row[1]}</td>
                <td style="color:${color}; font-weight:bold;">${row[3]}</td>
            </tr>
        `;
    });
}

// Load stats on startup
refreshStats();