import numpy as np
import pandas as pd
from sklearn.ensemble import RandomForestClassifier
import joblib

print("🧠 TRAINING AGGRESSIVE BRAIN...")

# Generate 10,000 transactions
X = []
y = []

for _ in range(10000):
    amount = np.random.uniform(5, 10000)
    hour = np.random.randint(0, 24)
    trans_type = np.random.randint(0, 2) # 0=Card, 1=Wire
    merch_risk = np.random.randint(1, 11) 
    
    is_fraud = 0
    
    # --- STRICT RULES FOR TRAINING ---
    # 1. Any Wire Transfer (Type 1) is automatically FRAUD
    if trans_type == 1:
        is_fraud = 1
        
    # 2. Any amount over $4000 is automatically FRAUD
    if amount > 4000:
        is_fraud = 1

    # 3. High Risk Merchant is FRAUD
    if merch_risk > 7:
        is_fraud = 1

    X.append([amount, hour, trans_type, merch_risk])
    y.append(is_fraud)

# Train the model
model = RandomForestClassifier(n_estimators=100)
model.fit(X, y)

# Save it
joblib.dump(model, 'guardian_brain.pkl')
print("✅ NEW BRAIN SAVED! It will now block Wire Transfers and High Amounts.")